
TYPE
	PMCConstantsType : 	STRUCT  (*Constants for the PMC system*)
		H2P_FRMC_OFFSET : UINT := 4;
		H2P_CMDC_OFFSET : UINT := 5;
		H2P_CMDID_OFFSET : UINT := 6;
		H2P_CMDLB_OFFSET : UINT := 8;
		H2P_DATA_OFFSET : UINT := 10;
		H2P_EVENTID_OFFSET : UINT := 130;
		H2P_STM_OFFSET : UINT := 132;
		H2P_DO_OFFSET : UINT := 384;
		P2H_FRMC_OFFSET : UINT := 4;
		P2H_CMDC_OFFSET : UINT := 5;
		P2H_CMDID_OFFSET : UINT := 6;
		P2H_CMDLB_OFFSET : UINT := 8;
		P2H_RTN_OFFSET : UINT := 10;
		P2H_DATA_OFFSET : UINT := 12;
		P2H_PMC_STATE_OFFSET : UINT := 54;
		P2H_REGION_STATE_OFFSET : UINT := 55;
		P2H_EVENT_OFFSET : UINT := 83;
		P2H_XBOT_STATE_OFFSET : UINT := 89;
		P2H_MUX_OFFSET : UINT := 128;
		P2H_REAL_TIME_OFFSET : UINT := 188;
		P2H_DI_OFFSET : UINT := 384;
		P2H_PROTOCOL_OFFSET : UINT := 0;
		PMC_TIMEOUT : UINT := 7500;
	END_STRUCT;
	PMCDBType : 	STRUCT  (*Stores PMC state and positions of all the xbots*)
		PMCState : USINT;
		PosX : ARRAY[0..254]OF REAL;
		PosY : ARRAY[0..254]OF REAL;
		PosZ : ARRAY[0..254]OF REAL;
		PosRx : ARRAY[0..254]OF REAL;
		PosRy : ARRAY[0..254]OF REAL;
		PosRz : ARRAY[0..254]OF REAL;
	END_STRUCT;
	PMCFuncInfoType : 	STRUCT  (*Stores the status of a single function block instance*)
		CmdSta : USINT;
		TicketNumber : USINT;
		EventID : UINT;
		SendToPMC : BOOL;
		ReadFromPMC : BOOL;
		MsgPartNStatus : DINT;
	END_STRUCT;
	PMControllerType : 	STRUCT  (*Tracks state of the entire PMC system*)
		H2P_START : UDINT;
		P2H_START : UDINT;
		ConfiguredFeedbackStreamAxis : USINT;
		PMCDB : PMCDBType;
		TicketMgmt : PMCTicketType;
		EventMgmt : PMCEventType;
		PMC_Constants : PMCConstantsType;
	END_STRUCT;
	PMCTicketType : 	STRUCT  (*Used to determine which function block has access to the fieldbus*)
		AvailableTicket : USINT;
		ExecutingTicket : USINT;
		TicketStatus : ARRAY[0..255]OF BOOL;
	END_STRUCT;
	PMCEventType : 	STRUCT  (*Tracks event IDs and event codes*)
		AvailableEventID : UINT;
		ExecutingEventID : ARRAY[0..5000]OF BOOL;
		EventCode : ARRAY[0..5000]OF USINT;
	END_STRUCT;
END_TYPE
